#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Point to PointMod01.fsh   by  Yusef28 
//https://www.shadertoy.com/view/fljGRd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define numSegments 23.
#define showSeg
#define PI 3.141592653589793238462643

#define bgCol   vec3(60, 47, 47)/255.*0.9
#define lineCol vec3(130., 144., 121.)/255.
#define circleCol vec3(237., 227., 185.)/255.*0.6

mat2 rot(float a){
    return mat2(cos(a), -sin(a), sin(a), cos(a));
}

float dotLineDist(vec2 A, vec2 B, vec2 p){

    vec2 pa = p - A;
    vec2 AB = B - A;
    
    //clamp = segment!
    float t = clamp(dot(pa, AB)/dot(AB,AB), 0., 1.);
    
    vec2 normal = pa - t*AB;
    float dist = length(normal);
   
    return dist;
}

vec3 drawRing(float radius, float thickness, vec2 p, vec2 off, vec3 col){
    
    p -= off;
    
    float eps = 1./min(iResolution.x,iResolution.y);
    
    float circle = 1.-smoothstep(-eps, eps, 
    abs(radius - length(p))-thickness);
    
    col = mix(col, circleCol, circle);
    
    return col;
}

vec3 drawLine(vec2 A, vec2 B, vec2 p, vec3 col){
    
    float dist = dotLineDist(A,B,p);
    //dist = 1.0-smoothstep(0.001, 0.002, dist);
    dist = abs(1.0-smoothstep(0., fwidth(dist), dist - 0.0012));
    return mix(col, lineCol, dist);
}

vec3 drawGradedLine(vec2 A, vec2 B, vec2 p, vec3 gradient, vec3 col){
    
    float dist = dotLineDist(A,B,p);
    
    //dist = 1.0-smoothstep(0.001, 0.002, dist);
    dist = abs(1.0-smoothstep(0., fwidth(dist), dist - 0.0012));
    return mix(col, gradient, dist);
}

/*

//loopless version by oneshade using floor to create cells
//because every point is fixed on the x axis
//Just need to make it aligned to start and end of screen
//for any number of segments.
vec3 drawSegments(vec2 viewDim, vec2 uv) {
    
    float aspect = viewDim.x/viewDim.y;
    vec3 col = bgCol;

    float dt = aspect / numSegments;
    uv.x += fract(0.5 * numSegments) * dt;
    col = drawLine(vec2(0.0, -0.25), vec2(0.0, 0.25), uv, col);

    float cell = floor(uv.x / dt) * dt;
    vec2 p1 = vec2(cell, sin(2.25 * PI * cell + iTime) * 0.25);
    vec2 p2 = vec2(cell + dt, sin(2.25 * PI * (cell + dt) + iTime) * 0.25);
    col = drawLine(p1, p2, uv, col);

    #ifdef showSeg
    col = drawRing(0.01, 0.003, uv, p1, col);
    col = drawRing(0.01, 0.003, uv, p2, col);
    #endif

    return col;
}
*/
//Original version

vec3 drawSegments(vec2 viewDim, vec2 uv, float r){

    float aspect = viewDim.x/viewDim.y;
    vec3 col = bgCol;
    float dx;

    float dt;
    vec2 firstPoint = vec2(r, 0);
    vec2 lastPoint = vec2(r, 0);

    vec2 tmp;
    float t = 0.;
    
    for(float i = 1.; i <= numSegments; i++){
        
        dt = 2.*PI*(i/numSegments)+3.*PI/2.;
        //t = dt;
        //dx = (aspect*dt-aspect/2.);

        vec2 newPoint = rot(dt)*firstPoint;
        
        col = drawLine(lastPoint, newPoint, uv, col);
        
        #ifdef showSeg
        col = drawRing(0.01, 0.003, uv, newPoint, col);
        #endif
        
        
        for(float i = 1.; i <= numSegments; i++){
        
            dt = 2.*PI*(i/numSegments);//+iTime/16.;
            tmp = rot(dt)*newPoint;
            col = drawGradedLine(newPoint, tmp, uv, cos(lineCol+dt*2.+vec3(0,2,4)/4.+iTime*2.)*0.5+0.75, col);
            }
        //t += numSegments;
        lastPoint = newPoint;
        
    }
    return col;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-iResolution.xy*0.5)/iResolution.y;

    vec3 col = drawSegments(iResolution.xy, uv, .6);
   
    //col = pow(col, vec3(0.75));
   
    uv = fragCoord/iResolution.xy;
    uv *=  1.0 - uv.yx;
    float vig = uv.x*uv.y * 8.0; // multiply with sth for intensity //was 15.0
    
    vig = pow(vig, 0.08); // change pow for modifying extend of vignette //was 0.15


    fragColor = vec4(col*vig,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

